## <img src="/Images/Icons/book.png" width="200" height="200" />

## Purpose of the book

_**"When all researchers are aware of Open Science, and are trained, supported and guided at all career stages to practice Open Science, the potential is there to fundamentally change the way research is performed and disseminated, fostering a scientific ecosystem in which research gains increased visibility, is shared more efficiently, and is performed with enhanced research integrity."**_ [Open Science Skills Working Group Report](https://ec.europa.eu/research/openscience/pdf/os_skills_wgreport_final.pdf#view=fit&pagemode=none) \(2017\)

Open Science, the movement to make scientific products and processes accessible to and reusable by all, is about culture and knowledge as much as it is about technologies and services. Convincing researchers of the benefits of changing their practices, and equipping them with the skills and knowledge needed to do so, is hence an important task.

This book offers guidance and resources for Open Science instructors and trainers, as well as anyone interested in improving levels of transparency and participation in research practices. Supporting and connecting an emerging Open Science community that wishes to pass on its knowledge, the handbook suggests training activities that can be adapted to various settings and target audiences. The book equips trainers with methods, instructions, exemplary training outlines and inspiration for their own Open Science trainings. It provides Open Science advocates across the globe with practical know-how to deliver Open Science principles to researchers and support staff. What works, what doesn’t? How can you make the most of limited resources? Here you will find a wealth of resources to help you build your own training events.

Building on the authors’ cumulative experience and skills of imparting Open Science principles, this handbook is oriented towards practical teaching in an open knowledge and educational setting. In other words, the focus of this handbook does not lie on spreading the idea of Open Science, but on _how to_ support Open Science practices most effectively.

## <img src="/Images/Icons/gears.png" width="150" height="150" />

## Who is this book for?

This handbook is intended for anyone who wishes to host Open Science training events or introduce Open Science concepts to discipline-specific training events, in order to foster the uptake of open research practices. This includes researchers, librarians, infrastructure providers, research support officers, funders, policy makers and decision makers. This handbook is also meant for all those who have regular or occasional contact with researchers \(and other stakeholders\) and wish to share their Open Science knowledge, either as part of their regular working duties or as an extra investment of time. Importantly, it will be of use to those who wish to host training events to foster reuse, participation, efficiency, equity, and sharing in research, regardless of whether they ascribe to \(or even wish to use\) the term Open Science.

In this handbook, we define "trainer" as any person wishing to run an Open Science training event, regardless of their levels of experience. Importantly, this includes those who would feel uncomfortable or do not wish to use the Open Science label in their teaching. The book contains advice on teaching concrete skills and concepts to improve the work of researchers. And while most fall under the umbrella term "Open Science", they needn’t be taught as such. Wariness of the label “Open Science” might mean that "Open Science" training only attracts a particular segment of researchers, whereas "How to publish your data" training attracts a more diverse group. Part of a trainer’s job is to define their target audience and how best to reach them, and so such decisions are best made by you!

## <img src="/Images/Icons/questions.png" width="150" height="150" />

## What is Open Science?

According to the [FOSTER taxonomy](https://www.fosteropenscience.eu/taxonomy/term/7), "Open science is the movement to make scientific research, data and dissemination accessible to all levels of an inquiring society."  It can be defined as a grouping of principles and practices:

* **Principles**: Open Science is about increased transparency, re-use, participation, cooperation, accountability and reproducibility for research. It aims to improve the quality and reliability of research through principles like inclusion, fairness, equity, and sharing. Open Science can be viewed as research simply done properly, and it extends across the Life and Physical Sciences, Engineering, Mathematics, Social Sciences, and Humanities \([Open Science MOOC](https://docs.google.com/document/d/1KuTSECSYHXZmZX15GDjyD65pJ90eRMhHVEZ-1trsw30/edit?usp=sharing)\).
* **Practices**: Open Science includes changes to the way science is done - including opening access to research publications, data-sharing, open notebooks, transparency in research evaluation, ensuring the reproducibility of research \(where possible\), transparency in research methods, open source code, software and infrastructure, citizen science and open educational resources.  
  A note on language: As the English word "science" traditionally does not include the humanities and social sciences, more explicitly inclusive terms like “open scholarship” or “open research” are often used. As “Open Science” is the more common term, we shall use it here, but it should be read as referring to research from all scholarly disciplines.

## <img src="/Images/Icons/arrow.png" width="150" height="150" />

## How to use the book

This handbook is designed in a modular way. Feel free to choose chapters and skip others that might not be relevant to you or your training.  
  In Chapter 2 you will dive into the content of your training. All topics pertaining to Open Science are presented and explained in this part of the handbook. Already familiar with one or two topics? Great, then have a look at other aspects you might not have heard of yet. Even if you are not planning to run training events on those exact topics, you will likely find them of use - there is a lot of overlap between Open Science topics.  
  If you have no or little prior knowledge about training in general, please have a look into Chapter 3: "On Learning and Training". It gives you an overview of training techniques as well as practical tips for designing your training. If you already have some experience you can also use it to learn about different teaching approaches and for refreshing your knowledge.  
  Bigger workshops and information events can require a lot of planning. Making your event a success will involve a lot of decisions, from the small to the large, which are time-sensitive. Chapter 4 provides helpful information about organizational aspects. It also offers a useful checklist to aid in planning your training.  
  Lively and interactive training events need engaging activities. Our example exercises and additional resources will engage your audience, give practical insight about theoretical topics, or provide you with feedback from your participants. Chapter 5 offers you a range of tested and approved exercises and resources by Open Science training experts. Feel free to test, reuse, and adapt them!  
  Like any other emerging field, Open Science uses quite a lot of sometimes difficult terminology. Some of it you may not be familiar with. Don’t lose heart! The "Glossary" will explain most of the less familiar terms and concepts.  
  This handbook was created to be a living resource. This means it will regularly be updated due to new developments in Open Science, as well as in response to feedback and suggestions from other Open Science trainers and our general audience. Please feel free to add your best practices, examples, resources, opinions or experiences via GitBook.  
  We hope you will enjoy reading this handbook and wish you all the best for your future Open Science training!

## <img src="/Images/Icons/open_licenses.png" width="150" height="150" />

## Open License and Credits

The Open Science Training Handbook is written as an Open Educational Resource to enable you to use this book in the best possible way. This work is therefore made available under [Creative Commons Public Domain Dedication \(CC0 1.0 Universal\)](https://creativecommons.org/publicdomain/zero/1.0/). You do not have to ask us permission to re-use and copy information from this handbook. Feel free to use information from the content session for your training slides or images that seem fitting in your training. Take note that some materials cited in this book might be copyright protected - if so, this will be indicated in the text. Please consider citing the handbook when using the content.  
  We have tried to acknowledge all of our sources. If for some reason we have forgotten to provide you with proper credits it has not been done with malicious intent. Feel free to contact us at [elearning@fosteropenscience.eu](mailto:elearning@fosteropenscience.eu) for any corrections.

