## <img src="/Images/Icons/shout.png" width="200" height="200" />
## 11. Open Advocacy

### What is it?

Advocacy in all its forms seeks to ensure that people, particularly those who are most vulnerable in society, are able to:

* Have their voice heard on issues that are important to them. Advocacy means giving voice to a group.

* Defend and safeguard their rights.

* Have their views and wishes genuinely considered when decisions are being made about their lives.

Advocacy include actions of defending, influencing, changing, decision-making, persuading, lobbying, attracting attention.

Open Advocacy focuses on the movement to promote Open Science at various levels of stakeholders, highlighting and stressing the societal, professional and personal advantages that it entails.

### Rationale

Trainings \(workshops, seminars, presentations\) can be used as advocacy tools. The structured approach to advocacy practices helps to address the main issues the trainer has to keep in mind if the training is connected to an Open Science advocacy program. how to use advocacy strategies as tools for effecting specific changes, and on building the basic skills necessary for employing advocacy tools \(e.g., ad campaigns, meetings with policymakers\). Training here is considered as a tool for effecting specific changes, and for building an Open Science advocate community.

## <img src="/Images/Icons/finish.png" width="150" height="150" />
### Learning objectives

1. Understand the context and goals of the advocacy program, 
2. Be able to communicate effectively with audiences and draw community’s attention to an important issue and directing decision makers toward a resolution.

### Key components

## <img src="/Images/Icons/brain.png" width="150" height="150" />
#### Knowledge

##### Objectives to achieve

SMART is a way of reminding you that your objectives should be:

**S**pecific — by this we mean that you need to set a specific objective for your programmes.

**M**easurable — your objective should be measurable.

**A**chievable — the objective should be attainable or practicable.

**R**ealistic — which also means credible.

**T**ime-bound — and should be accomplished and achieved within a certain amount of time.

Objectives can be long term or short term. Long-term objectives usually focus on changing the policy or practice of institutions, whereas shorter-term objectives can focus on attitude changes, raising awareness, getting an issue on the agenda, building a constituency of support or movement for change. It may be necessary to achieve some of the short-term objectives before you can achieve the longer-term ones.

Main goals of advocacy program:

* to increase awareness among influential groups and the public;

* to reduce stigma and fear

* to engage and mobilize key stakeholders within the community who will champion the development

* to expand advocacy groups, including community volunteers

* to mobilize resources to support the implementation of key priority \(core\) interventions;

* to maintain the involvement of decision-makers and the public l by disseminating information on achievements to date and future challenges.

##### Steps to good advocacy

1. Define your goals
   1. What needs changing?
   2. What do we want to ask for? Changing legislation, policy, regulation, programs, funding
2. Understand your audience: different strategies for each target
3. Build a profile of open access stakeholders and their attitudes.
4. Craft your message: create compelling messages that appeal to stakeholders’ interests
   1. Be clear on what we are asking for
   2. Keep it simple and focussed
   3. Use positive language
   4. Use evidence - facts carry more weight than anecdotal evidence
   5. Economic arguments are important
5. Plan and develop your communication and advocacy campaign
6. Identify Delivery Methods:
   1. Advocacy is relationship building,
   2. Tactics change by target audience
7. Identify Resources and Gaps:
   1. Do a SWOT \(strengths, weaknesses, opportunities and threats\) analysis
   2. Build on existing resources and opportunities
8. Plan Next Steps Identify achievable goals that set stage for larger work: advocacy strategy/plan
9. Evaluate Effectiveness Regularly

##### Aspects of advocacy

* Advocating for your own rights as an author

* The basic steps for achieving local culture change [http://study.com/academy/lesson/kotters-8-step-change-model-of-management.html](http://study.com/academy/lesson/kotters-8-step-change-model-of-management.html)

* Advocating to your peers: Writing letters and articles advocating for Open

* Talking to journal editors - having the OA conversation with your field

* Talking to policymakers

##### Tools and methods

**Indirect**: stimulate participants to take action on their own behalf,

**Direct:** lobbying before decision makers by representatives on behalf of others.

**Campaigning:** generating a response from the wider public and using a variety of techniques such as:

* chain e-mail or letter

* opinion pieces and letters to the editor in newspapers

* newsletters

* celebrity endorsements

* media partnerships with newspapers, journalists and film-makers

* web-based bulletins and online discussions

* public events

* large-scale advertising campaigns.

* use of social media \(Twitter, Facebook\)

## <img src="/Images/Icons/gears.png" width="150" height="150" />
#### Skills

* Write a letter for a newsletter or forum for your scholarly society about Open Access.

* Make your own email template reply about only reviewing for OA journals, etc. Reuse/base it on ones out there already.

* Outline concrete solutions and benefits Open Science can deliver for current headaches university administrators may struggle with.

* Find your local advocacy group and volunteer for them!

## <img src="/Images/Icons/questions.png" width="150" height="150" />
### Questions, obstacles, and common misconceptions

Lack of interest from audiences. Lack of understanding the value.

The institution and/or senior management is concerned about the impact of the advocacy efforts.

## <img src="/Images/Icons/output.png" width="150" height="150" />
### Learning outcomes

The trainer will be able to consider the training event in the context of a program.

## <img src="/Images/Icons/magnifying_glass.png" width="150" height="150" />
### Further reading

* [Starting Open Projects From Scratch](https://docs.google.com/document/d/1qSXBZa3-uBKdkFCkukt5lxRsYoREWNYf0_2OpOnh3mQ/edit?usp=sharing) \(CC0, Crowdsourced by OpenCon attendees\)

* SPARC author addendum - [advocate for your own rights as an author w/ a journal](https://sparcopen.org/our-work/author-rights/)

* Bolick et al. rebuttal article written in the Journal of Wildlife Management after a misleading / fear mongering article about OA: [https://kuscholarworks.ku.edu/handle/1808/22672](https://kuscholarworks.ku.edu/handle/1808/22672?utm_content=buffer40244&utm_medium=social&utm_source=twitter.com&utm_campaign=buffer)

* Perhaps some of the Lingua / Glossa articles on their move away from Elsevier - their advocacy as editors with a publishing organization

* Another example of a letter to a scholarly society advocating for Open Access: [Jackie Smith to the American Sociological Association](http://www.asanet.org/sites/default/files/savvy/footnotes/mayjun14/asaforum_0514.html)  and [another article](https://www.opendemocracy.net/jackie-smith/defending-global-knowledge-commons).

* eLife ECRwednesday webinar, May 31, about advocating for Open Science - video will be available on YouTube shortly. Featured Gary McDowell, Nick Shockey, Osman Aldirdiri, Corina Logan, Brianne Kent. Advice pitched at early-career researchers.

* [Advocating for transparency policies - a toolkit for researchers, staff, and librarians ](https://github.com/AllTrialsUSA/FSCI2017/blob/master/Transparency-advocacy-toolkit.md)\(April Clyburne-Sherin \(FSCI2017\)\)

* [Advocating Open Access - a toolkit for librarians and research support staff](http://blogs.ucl.ac.uk/open-access/files/2015/06/Advocacy-toolkit.pdf) \(UCL\).

* [Open science and its advocacy](https://www.fosteropenscience.eu/content/open-science-and-its-advocacy) \(FOSTER\).

* [FOSTER Plus: Supporting the practical adoption of Open Science](http://libereurope.eu/our-activities/projects/fosterplus/) \(LIBER\).

* [Open Science Leadership Workshop](https://github.com/mozillascience/open-science-leadership-workshop), Mozilla Science Lab.

* [Strengthen Advocacy](http://sites.path.org/advocacyandpolicy/how-we-do-it/strengthen-advocacy-capacity/) Capacity \(PATH\).

* [Retraction Watch](http://retractionwatch.com/)

* [8 Steps to Good Advocacy](http://www.chpca.net/media/7413/8_Steps_to_Good_Advocacy.pdf)



