## <img src="/Images/Icons/world.png" width="200" height="200" />
## 10. Citizen Science

### What is it?

Citizen Science is the involvement of the non-academic public in the process of scientific research – whether community-driven research or global investigations \([citizenscience.org](http://citizenscience.org/)\). Citizens do scientific work—often working together with experts or scientific institutions. They support the collection, analysis or description of research data and make a valuable contribution to science. The first documented Citizen Science project took place at Christmas in 1900 in the USA, when the National Audubon Society carried out a [Christmas Bird Count](http://www.audubon.org/conservation/science/christmas-bird-count). "[Galaxy Zoo](https://www.galaxyzoo.org)" with over 150,000 participants who classified galaxies in one year is probably the so far most successful Citizen Science project.

Citizen science is essentially a direct product of successful science communication or public engagement. In the age of digital networked technologies, researchers have a wealth of channels through which to disseminate their work to wider non-academic audiences. Whereas research has been traditionally disseminated narrowly via conference papers, research articles and book publications, researchers now can use blogs, social media, video-hosting sites, and a wide range of social digital networks to target and broaden their dissemination activities.

### Rationale

Citizen science is both an aim and enabler of Open Science. It can refer to citizens actively and openly participating in the research process itself, often through crowdsourcing activities.This includes aspects such as data collection, data analysis, volunteer monitoring, and distributed computing. Alternatively, it can also mean greater public understanding of science facilitated through greater access to information about the research process, including the ability to use open research data and to access to journal articles openly available. The latter \(aka Do-It-Yourself Science\) involves examples such as patient innovation, patient activism/advocacy, NGOs and Civil Rights Groups. This leads to a clearer classification by distinguishing scientist and non-scientist led activities \(see [Outside the Academy – DIY Science Communities](https://speakerdeck.com/lu_cyp/outside-the-academy-diy-science-communities)\). The public can also be engaged in policy making through, for example, agenda-setting for research systems’ \(see the [European Commission’s Open Science Monitor](https://ec.europa.eu/research/openscience/index.cfm?pg=citizen&section=monitor)\).

"_Citizen Science and Open Science together can address grand challenges, respond to diminishing societal trust in science, contribute to the creation of common goods and shared resources, and facilitate knowledge transfer between science and society to stimulate innovation. The issues of openness, inclusion and empowerment, education and training, funding, infrastructures and reward systems are discussed regarding critical challenges for both approaches. You might consider Citizen Science and Open Science jointly, to strengthen synergies by building on existing initiatives, launching targeted actions regarding education and training, and infrastructures_". Extracted from the [Policy Brief on Citizen Science and Open Science](https://ecsa.citizen-science.net/sites/default/files/ditos-policybrief3-20180208-citizen_science_and_open_science_synergies_and_future_areas_of_work.pdf) by the European Citizen Science Association \(ECSA\)

## <img src="/Images/Icons/finish.png" width="150" height="150" />
### Learning objectives

1. Understand the different aspects of citizen science \(collaborative versus DIY\).

2. Understand the basic concepts and viewpoints of a variety of stakeholders in science communication.

3. Management of intellectual property in citizen science projects. A guide for this is available [here](https://www.wilsoncenter.org/sites/default/files/research_brief_guide_for_researchers.pdf).

4. Management of [citizen science data](http://www.ukeof.org.uk/documents/DataAdviceNote2.pdf).

5. Identify the best strategies in establishing clear and concise communication of scientific principles.

6.  What are the best ways to communicate your research/story, with whom, and using what tools.

### 

### Key components

## <img src="/Images/Icons/brain.png" width="150" height="150" />
#### Knowledge

The European Citizen Science Association \(ECSA\) created a best practice guideline on what constitutes good citizen science and wrote the [10 principles of Citizen Science](https://ecsa.citizen-science.net/engage-us/10-principles-citizen-science). This statement has been translated into many languages. Those 10 principles offers a guidance of best practices for any project based on Citizen Science.

When starting a citizen science project there are a few key elements that must be take into account: how are you going to engage citizens? how are you going to ensure data quality? how are you going to deal with ethics and legal issues?

Although there is still an open debate on how to assess some citizen science activities there are already some examples that can be included as societal impact in evaluation reports like the [cases studies](http://impact.ref.ac.uk/CaseStudies/Results.aspx?val=%22Citizen+Science%22) extracted from the UK Research Excellence Framework.

## <img src="/Images/Icons/gears.png" width="150" height="150" />
#### Skills

* Be able to differentiate in different citizen science project approaches: projects where citizens just provide data versus projectes where the citizen engagement is along the research project.

* Be able to provide advice on legal and ethical aspects regarding the collection of data, including personal data from citizens.

* Be able to provide different solutions on sharing research outputs.

## <img src="/Images/Icons/questions.png" width="150" height="150" />
### Questions, obstacles, and common misconceptions

* One of the controversies that usually arise in citizen projects is how researchers make data gathered by citizens publicly available. Researchers should be aware on how this data can be shared taking into account legal and ethical aspects.

* The lack of rewards for citizen science practices if they do not end in a "traditional" research output: paper, proceeding etc. is a common issue when training on citizen science. Probably a good way to overcome this issue is to start a conversation on how participants would like to get rewarded and which methods they propose.

## <img src="/Images/Icons/output.png" width="150" height="150" />
### Learning outcomes

1. Trainees will be able to know the different approaches of citizen science projects and how to deal with legal and ethical aspects, especially in relation with data management. 
2. Participants in the training sessions would learn how to engage citizens in their research at any point of their research activities.

## <img src="/Images/Icons/magnifying_glass.png" width="150" height="150" />
### Further reading

* [White Paper on Citizen Science for Europe](http://www.socientize.eu/sites/default/files/white-paper_0.pdf)

* Citizen science for all. [A guide for citizen science practitioners](http://www.buergerschaffenwissen.de/sites/default/files/grid/2017/11/20/handreichunga5_engl_web.pdf), Bürger schaffen Wissen.

* [Green Paper-Citizen Science Strategie 2020 for Germany](http://www.buergerschaffenwissen.de/sites/default/files/grid/2017/11/21/gewiss_cs_strategy_englisch_0.pdf), Bürger schaffen Wissen 

* [Community Planning Toolkit-Community Engagement](https://www.communityplanningtoolkit.org/sites/default/files/Engagement.pdf)

* Overview of citizen science projects:

  * [http://socientize.eu/](http://socientize.eu/)

  * [https://www.zooniverse.org/projects](https://www.zooniverse.org/projects)

  * [https://crowdcrafting.org/](https://crowdcrafting.org/)

* François Grey, Daniel Wyler, Judith Fröhlich, Katrien Maes 2016: [Citizen science at universities. Trends, guidelines and recommendations ](https://www.leru.org/publications/citizen-science-at-universities-trends-guidelines-and-recommendations)

* Citizen Science Training School [Example](https://www.cs-eu.net/events/internal/citizen-science-training-school)



