## <img src="/Images/Icons/open_education.png" width="200" height="200" />
## 11. Open Educational Resources

### What is it?

Open Educational Resources (OER) are defined as "teaching, learning and research materials in any medium – digital or otherwise – that reside in the public domain or have been released under an open license that permits no-cost access, use, adaptation and redistribution by others with no or limited restrictions" ([William and Flora Hewlett Foundation definition](https://www.hewlett.org/strategy/open-educational-resources/)). Open educational resources include full courses, course materials, modules, textbooks, streaming videos, tests,  images, software, and any other tools, materials, or techniques used to support access to knowledge.

### Rationale

In many cases open educational resources are build upon research findings. If you are an Open Science practitioner it makes sense that your educational resources maintain the level of openness of your research. Moreover other instructors could use your material to elaborate new resources or adapt existing ones. In fact the creation of educational resources can be seen as a cycle similar to the research cycle: find, compose, adapt, use, and share ([wikieducator.org/OER_Handbook/educator/OER_Lifecycle](http://wikieducator.org/OER_Handbook/educator/OER_Lifecycle)).

## <img src="/Images/Icons/finish.png" width="150" height="150" />
### Learning objectives

1. Participants should learn the difference between open and non-open educational resources.
2. Licensing is an essential part and indicates how to easily use and combine OER.
3. Participants should know where to find and place created OER resources.

### Key components
## <img src="/Images/Icons/brain.png" width="150" height="150" /> <img src="/Images/Icons/gears.png" width="150" height="150" />
#### Knowledge and Skills

Open Educational Resources are only OER, if they have an open license. However, there is no clear guideline for the choice of license for your resource. So what kind of license is appropriate? In practice, Creative Commons (CC) licenses are most often used for OER. 
Open Creative Commons licenses are [CC0 (Public Domain Dedication)](https://creativecommons.org/publicdomain/zero/1.0/), [CC BY (Attribution)](https://creativecommons.org/licenses/by/4.0/) and [CC BY-SA (Attribution-ShareAlike)](https://creativecommons.org/licenses/by-sa/4.0/), which can be used for most educational resources. For the distribution of databases under a free license, Creative Commons is not ideal. Rather, choose a specially suitable open license such as ODbl, ODC-BY or PDDL to be legally compliant.

It is important to stress the need to define who holds copyright or any other related rights of the research output. The copyright holder is the one who can decide to lift restrictions if they are not lifted by default through the licenses. Licenses should therefore be explained in detail to properly attribute authors and to create true OER. This also includes the combination of different license types and its consequences.

Training should provide an overview of OER platforms and their intended use. OpenCourseWare (OCW) is one of the first open educational resource platforms and one of the key initiators of the open educational resources movement. Initiated at the Massachusetts Institute of Technology (MIT) in 2002, the [Open Education Consortium](http://www.oeconsortium.org) now provides materials from all over the world in form of courses under free licenses. Other pioneers were UNESCO and the William and Flora Hewlett Foundation which are still committed to open educational resources.

Examples for OER platforms are:

- [Creative Commons Search](https://search.creativecommons.org/)) for image, audio, and video files
- [Open Education Consortium](http://www.oeconsortium.org)) for open course material
- [OERCommons](https://www.oercommons.org/)) for educational resources

## <img src="/Images/Icons/questions.png" width="150" height="150" />
### Questions, obstacles, and common misconceptions

Q: How can you ensure quality of the materials?

A: This is not always a given. So far there is no quality seal for OER materials. Open user comments, peer review, and the publication of materials on platforms of established institutions like e.g. universities can provide a first indication of quality. Just as with printed text materials, quality can though not be guaranteed. This unsettles many users. The actuality and adaptability of the materials nevertheless speaks for the use of OER. At the end of the day, you only know yourself whether the selected material is suitable for the intended purpose and whether its content is correct.

## <img src="/Images/Icons/output.png" width="150" height="150" />
### Learning outcomes

1. Trainees will be able to distinguish between copyrighted and free materials. 
2. The combination of different license types and their effects will be known. 
3. They will be able to find, use and create Open Educational Resources. 

## <img src="/Images/Icons/magnifying_glass.png" width="150" height="150" />
### Further reading
Butcher, Neil (2015): A Basic Guide to Open Educational Resources (OER): [hdl.handle.net/11599/36](http://hdl.handle.net/11599/36)

Miao, Fengchun; Mishra, Sanjaya; McGreal, Rory (2016): Open Educational Resources: Policy, Costs and Transformation: [hdl.handle.net/11599/2306](http://hdl.handle.net/11599/2306)

OECD (2007): Giving Knowledge for Free: The Emergence of Open Educational Resources. OECD Publishing, Paris: [/dx.doi.org/10.1787/9789264032125-en](http://dx.doi.org/10.1787/9789264032125-en)

Open Knowledge Foundation (2014): Open Education Handbook 2014: [education.okfn.org/handbooks/handbook/](https://education.okfn.org/handbooks/handbook/)
