## <img src="/Images/Icons/timetable.png" width="200" height="200" />
## Organizational aspects

This chapter will guide you through the main practical aspects of organising a training event. Of course, what you need and will use will depend on the type of event you’ll organise! The checklist should be adjusted accordingly. You will get information on preparation steps and necessary organizational tasks. This will provide you not only with valuable knowledge about event organization, but will reassure you while preparing your training. Note that most of the material in this chapter, and the whole handbook, is focused on training regarding practical workshops. Running a different type of event may require different decisions than the recommendations that follow.

## Training event basics

### Format

Deciding what type of event you want to coordinate is the first critical step in training exercises. Here are some points to consider:

* Format of the training: live workshop, seminar, lecture, online training or mixture of online and in-person?

* Will it be participatory, formal, self-contained?

* Can the event be integrated into existing curricula?

* Do you need to invite any other external experts? What are the requirements for that (e.g., funding)?

* Is the training a requirement, or something participants are choosing to attend?

* Will attendees receive any form of accreditation for the training?

* What sort of venue type do you need for this format?

To provide you with initial guidance over possible types of training and their characteristics, see the table below for recommendations. 

<table>
  <tr>
    <td></td>
    <td>TYPE OF TRAINING</td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td></td>
    <td>Live workshop</td>
    <td>Course/ class</td>
    <td>Lecture</td>
    <td>Online Training</td>
  </tr>
  <tr>
    <td>Audience Size</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>less than 20</td>
    <td>x</td>
    <td>x</td>
    <td>x</td>
    <td>x</td>
  </tr>
  <tr>
    <td>less than 40</td>
    <td></td>
    <td>x</td>
    <td>x</td>
    <td>x</td>
  </tr>
  <tr>
    <td>more than 40</td>
    <td></td>
    <td></td>
    <td>x</td>
    <td>x</td>
  </tr>
  <tr>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Funds</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>none</td>
    <td></td>
    <td></td>
    <td>x</td>
    <td>x</td>
  </tr>
  <tr>
    <td>little</td>
    <td>x</td>
    <td>x</td>
    <td>x</td>
    <td>x</td>
  </tr>
  <tr>
    <td>loaded</td>
    <td>x</td>
    <td>x</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Time</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td> less than ½ day</td>
    <td>x</td>
    <td>x</td>
    <td>x</td>
    <td>x</td>
  </tr>
  <tr>
    <td>½ - 1 day</td>
    <td>x</td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>1- 4 days</td>
    <td>x</td>
    <td>x</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>more than 4 days</td>
    <td></td>
    <td></td>
    <td>x (series)</td>
    <td>x (series)</td>
  </tr>
  <tr>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Training level</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Introductory</td>
    <td></td>
    <td></td>
    <td>x</td>
    <td>x</td>
  </tr>
  <tr>
    <td>Aware of</td>
    <td>x</td>
    <td>x</td>
    <td></td>
    <td>x</td>
  </tr>
  <tr>
    <td>Intermediate</td>
    <td>x</td>
    <td>x</td>
    <td></td>
    <td>x</td>
  </tr>
  <tr>
    <td>Advanced</td>
    <td>x</td>
    <td>x</td>
    <td>x</td>
    <td>x</td>
  </tr>
</table>



### Audience, guest speakers, and partners

Before committing to the event be sure you defined your target audience and that you are aware of their needs. Consider your audience, its size and the number or area of competence of (guest) trainers. [link to On learning and training chapter: Target audiences]

## <img src="/Images/Icons/collaborate.png" width="150" height="150" />
#### Cooperating with others

Some forms of training require more than one instructor. Try to get support from colleagues or service units in your institution. Identify institutional support (e.g., funding, room(s), work time) and reach out to decision makers to ask for these things - for example, you could ask for help with registration, or contact the printing service or communication department regarding advertising. Make sure any volunteers are sufficiently briefed on all activities, and know what the aims and practicalities of the event are. Make them aware of the importance of encouraging participation from the attendees. You can also outsource some tasks, if the budget allows for this.

Consider partnering with other departments at your institution or other local institutions to pool resources and increase impact/collaborating with other projects or programs. These are the key points to work out prior to committing to, or announcing any event. Resolving these will help the training run smoothly for yourself and your participants. Also consider integrating the training into a recognized conference or local/international event.

Identify other trainers or experts/guest speakers that could help with the event. Ideally these will be other Open Science advocates at the institution or otherwise local to the event, but you may need to find suitable non-local trainers (who may need financial support for travel). Work to have diverse representation (see Representation below). According to [The Carpentries](https://software-carpentry.org/workshops/operations/), a workshop with 40 people needs at least two trainers (and possibly a third) who alternate between talking and supporting learners, including also one helper per 5 participants that will continuously monitor for any issues.

#### Representation

Maintaining an inclusive environment is important for any successful training event. Ensure that each component of your programme includes a range of backgrounds. Your organizing team, speakers, and trainers should include representation across gender identities, different disciplines, underrepresented groups, diverse racial backgrounds, and geographic regions (if you intend to open your event to non-local participants). 

Actively invite trainers and speakers from underrepresented groups. Make sure to discuss with them their specific goals and needs, and include these in the planning of the event. To learn more about trainers see On learning and training chapter, Expectations about a trainer subchapter. Ensure that a proportion of participant spots are reserved for attendees across ethnic backgrounds, gender identities, disciplines and geographic regions [link to On learning and training chapter: Inclusive engagement]. To learn more about how to make your workshop inclusive and welcoming, see the [Conference Planning Checklist by SPARC](https://sparcopen.github.io/opencon-dei-report/checklist.html).

## <img src="/Images/Icons/home.png" width="150" height="150" />
### Venue

Before organizing a face to face training event consider few things related to a venue. It might help you to reduce several obstacles: 

The venue should be easily accessible for the participants. The venue should have elevator access, accessible entrances and ramps and clear legible signs. Check if the venue is easily accessible by public transport or car (parking spaces) and that it’s not too far away from rail stations or the airport. For a checklist of what makes a workshop accessible, see the [Accessible Meetings Toolkit from the American Bar Association](http://www.americanbar.org/content/dam/aba/administrative/mental_physical_disability/Accessible_Meetings_Toolkit.authcheckdam.pdf) and the [Conference Planning Checklist by SPARC](https://sparcopen.github.io/opencon-dei-report/checklist.html). Locate a place to greet your attendees and a place for them to circulate and socialise. A separate area for catering should be available. Also check if the venue offers a maternity room, a prayer room and a gender neutral washroom. 

The training room should be sufficiently equipped (see equipment and media). The room should have sufficient WiFi and power access for every participant (possibly via power strips/extension cords). Check to see if furniture can be rearranged in order to suit your requirements. The presenter will need a high (or raisable) table for standing and a microphone (for recording and/or accessibility). An additional microphone for participant questions aids accessibility. 

## <img src="/Images/Icons/break.png" width="150" height="150" />
### Timing

The length of the event depends on the content and depth of the training you intend to provide. You should have an estimate how much time each component will take. Make sure to define an agenda or time schedule, including any icebreakers and introductions. Allow enough time for lunch and coffee breaks. Be reasonable with your start and end times  [link to On learning and training chapter: Starting the training]. 

Before scheduling your event think about obstacles that might prevent or induce people to join and try to pick a suitable time and date of the event. Make sure to avoid conflict with any public holidays, religious holidays, or similar events. If your event is hosted at a university, keep class schedules in mind. Consider to place your training session along with a larger conference or meeting in order to bring more attention, increase the attendance and get the chance to bring any speaker attending the other event.  A family friendly workshop should avoid evenings and weekends, provide childcare or childcare sponsorships, and ensure areas for breastfeeding mothers. 

## <img src="/Images/Icons/budget.png" width="150" height="150" />
### Budget

You may need financial support to help run your event, to pay for things like the venue (if the host institution cannot or will not provide this for free), travel support for non-local trainers/experts, refreshments, materials (e.g., name badges, USB drives) and swag. Most types of training will need at least a little money for material and equipment. Also keep in mind that the costs associated with human resource are often the largest costs associated with running an event. It is good to identify time needed for staff to prepare materials and content which is often not budgeted for. These costs may be covered through as a core aspect of the job, but if not it might be wise to ensure funding to cover this aspect is sourced.

Consider different ways of creating a budget for your training. If possible request funds from your institution. Otherwise you might have to charge a fee from participants or look for scholarships and other ways of funding. 

#### Fee

Collecting and managing funds or fees can be tricky. If you plan to do this, you should consider using an existing online registration service (e.g., Eventbrite, Event Smart) or your institution’s conference/event services. Although any cost impacts accessibility of the event, charging a nominal registration fee (e.g., $20–40 or €15–30) encourages those who register to actually attend—Software Carpentry found this reduced no-shows from almost a third to about 5% (Wilson 2016). 

If planning to charge a fee of any sort, it is good to clarify with your institution's finance team how best to handle this. In some cases, the amount of time/effort required to set such things up can outweigh the value of charging - particularly if it is only a nominal fee being charged. Your institution will likely have specific financial processes and budget codes that need to be used so speak to them early on to see what is the best approach. This is true even when using external services such as Eventbrite (you'll need an institutional budget centre to allow the income to come into your institution).

If you do charge a fee, consider making a waiver available upon request for those unable to pay or creating scholarships. Scholarship allocation should be prioritized for groups that face the most barriers for self-funding.

#### Funding

You can get funding from a few difference sources: the host institution, external sponsors like companies, budgeted funds on faculty/principal investigator’s grants, or through registration fees. Check if there are any internal sources for funding, or relevant local organizations who can sponsor your event. If you have found a potential partner, check the funding conditions. This could include advertising on your event website or at the event itself.

Consider different levels of sponsorship (bronze, silver, gold) in case of bigger events. You might also want to look at other projects or programs to co-organize and  share costs with. 

## Organizational tasks 
## <img src="/Images/Icons/laptop.png" width="150" height="150" /> <img src="/Images/Icons/wifi.png" width="150" height="150" />
### Equipment & Media 

#### Long-term preparation

Here are some things to consider:

Will participants need access to WIFI? Make sure that any requirements for access are dealt with ahead of time (e.g., by providing guest account details). Check if the venue has enough power outlets. Make sure to check with the venue owner in advance for availability of technical support. If you are planning on recording the event make sure you have the correct equipment, and that attendees are aware (and have consented) to being recorded. Think about how you are going to license any outcomes: will you apply a CC license to pictures, videos, and training materials? Are the authors ok with that? 

#### Shortly before event

Making sure that all of your equipment, media, and materials are in fully functioning order can help to avoid any embarrassing hiccups during your training. Make sure that your laptop, or the device which is hosting your material, is compatible with the media technology in the venue. Ask guest lectures for their presentations in advance and store them all on the same laptop. This will make it easier to switch from one speaker to the other. Make sure to bring any relevant adaptors or extensions. Check WiFi strength and power outlets, as well as, if the speaker and projectors work in advance, and that your file formats are supported. Make sure there is an emergency contact for technical issues.

Make sure to print out any paper handouts in advance, and to have enough of them to go around. If you plan to hand out a lot of material, consider providing folders or binders to help with organization. Or, consider just making all your material available digitally via your event website.

Preparing a variety of media can help engage an audience with diverse learning styles. You should prepare any teaching aids in advance (e.g, flipcharts, practical exercises, games). Bring notepads, post-it notes, pens, thumbtacks. If participants need any other computer-based materials make sure these are well-organized and available in advance.

#### During the event

If your equipment fails, do not panic. Call the IT support and explain the problem to the attendees. Most people understand that. What might feel like hours to you are just a few minutes of lost time. If the equipment still not works try to work offline with flip charts for example. If you are relying heavily on media equipment and it is just a small group of participants suggest to reschedule the training.

## <img src="/Images/Icons/shout.png" width="150" height="150" />
### Marketing & Advertising Strategy

#### Long before the event

Developing a strong marketing and communication strategy is fundamental to driving participation, as well as teaching you how to develop and refine your messaging.

Consider which kind of name your training will have. Think about your framing and messaging. What are the common values that you can appeal to? For example, will you run an "Open Access workshop", or a workshop on “How to get published”? How are you going to get people in the room? Remember, training is not unidirectional, and can be incentivized by framing it as a networking opportunity. For example, find some partners in Graduate Schools, Master Schools, Support Staff trainings, Valorisation Center etc.

Consider both digital and non-digital media. Use institutional mailing lists and social media (e.g., Twitter, Facebook, blog). Will you have dedicated social media profiles? What sort of content will you share on them? Think about relevant images and logos. This is more important if you want to run more than one event. If the event is being run with the sponsorship of, or in coordination with, an institutional organization (e.g., the library, a particular college/department), then you may want or need to use the profiles of the organization. This might require someone else to post the material, so keep that in mind. Several of these recommendations might require organizational sign off or additional budget support - start investigating these options as soon as possible. 

Find out if you can post flyers or posters at your institution. Are you going to design a poster? What sort of logos, images, text, and information do you need to include? Make sure to clearly communicate the pre-defined objectives (skills and knowledge). Ask relevant organisations to help with advertising. Connect with relevant media, create a press release. Use existing communication channels, e.g. at the university library you might ask subject librarians to promote the event to their academic communities.

#### Shortly before the event

Send a reminder on social media and mailing lists. Put up signs so your attendees find the room.

#### During the event

Publish pictures and short videos from the event on the website and social media. Tell participants the hashtag for the training and ask them to send at least one tweet/message during the event. Collect reasons for attendance for advertising of future events.

## <img src="/Images/Icons/check.png" width="150" height="150" />
### Registration

#### Long before the event

Set up an event registration using a service like [Eventbrite](https://www.eventbrite.com) or [Event Smart](https://eventsmart.com) (which are free for free events, but may include fees if your event has a registration cost), or something like Google Forms to capture basic information. For smaller events you can also use registration via email. But don’t forget to send them a confirmation, when they register and before the event to send a reminder. 

Think about the fee you want/need to charge (see budget). Think about the credits students can get. Is a certificate needed (see certification of attendance)?

Be sensible and transparent about the information you collect. If you need to ask information like gender, age or nationality, keep into account that this is not always as straightforward as you might think - always offer the option of a blank field. Please do not use the distinction between Mrs and Ms.

You can make a short poll to measure what do participants already know about the topic (their pre-knowledge). It can help you to prepare training material. Make clear what data is going to be shared/retained and why. Always offer people the option of opting out, and keep any information you do archive safely stored. Consider creating a list of interested participants for a newsletter or for keeping in touch, but be aware of data protection (like the EU General Data Protection Regulation (Regulation (EU) 2016/679)). 

#### Shortly before the event

Depending on the size of the audience, provide a separate staffed registration desk. Make sure staff has all information including a participants list, and let them take care of badges and attendance sheets/certificates. 

If there is no separate registration desk, prepare a cheat sheet with information to keep at hand (think: public transportation, emergency numbers, requests for certificates, safety during the event  etc.). 

#### During the event

Do you have consent from participants to re-use or share their contact information or to take pictures and publish them? Did all participants sign the participants list?

## <img src="/Images/Icons/email.png" width="150" height="150" />
### Communication

#### Long before the event

Prepare and send formal invitations to participants, guest and keynote speakers. 

Create a website for the training event, such as using GitHub Pages or on an institutional website. [link to examples/template]

Make sure any key resources are visible and accessible if needed. If you want the participants to come with research outputs (e.g., papers, code, data) for exercises, let them know with plenty of time to prepare (and consider making this optional).

#### Shortly before the event

Communicate requirements to your audience in advance.

* Let them know if they need to bring laptops or other work materials.

* Make sure any prerequisites for software or programming abilities are communicated in advance.

* Provide basic contextual reading materials, so you don’t have to start at the beginning point.

Send a reminder email to your attendees a day or two in advance of the event, if possible (this may not be necessary if you are relying on a registration service). 

Remind people about reachability and accessibility of the venue. Send detailed instructions for parking and public transport options.

#### During the event

Dedicate some time to housekeeping at the start of your event. Write down hashtags and WIFI passwords.

## <img src="/Images/Icons/lunch_break.png" width="150" height="150" />
### Catering

#### Long before the event

What refreshments will you either need to provide, or will people need to bring their own? If you provide refreshments, you may need to obtain funding or charge for registration. 

If relevant, you can ask during registration in advance for dietary requirements - but keep in mind this might make it very complicated for you. Sometimes it’s better to ask the caterer to provide sufficient varieties (vegetarian, vegan, gluten free, etc.) and add one free field on your submission forms so that participants can fill in specific requests if necessary (e.g. intolerances and allergies). 

#### Shortly before the event

Check the venue and inform the caterer where and when to deliver the refreshments. 

#### During the event

Be sure you have the contact information of the caterer if the catering is not showing up, delivering the wrong lunch or forgot something.

## <img src="/Images/Icons/write.png" width="150" height="150" />
### Code of Conduct

#### Long before the event

To help ensure your workshop is a friendly, inclusive, and respectful environment for trainers and participants, identify or create a robust Code of Conduct (CoC) for your event. Make sure the Code of Conduct is communicated in advance—we recommend prominent placement on your event website (see task 2) and onsite. Participants should be asked to review and acknowledge the Code of Conduct while registering for the workshop. Included in your Code of Conduct should be clear consequences of violation (for example, removal from the workshop). Ensure the reporting process for violations is communicated clearly before and during the event and that at least one designated organizer is identified as the point of contact, who is easily accessible to receive reports of code of conduct violations. Examples you can borrow or adapt from include: 

* [The Mozilla Science Lab Code of Conduct](https://science.mozilla.org/code-of-conduct)

* [Contributor Covenant Code of Conduct](https://www.contributor-covenant.org) 

* [FORCE2017 Conference Code of Conduct](https://www.force2017.org/information/code_of_conduct.html)

* [The Carpentries Code of Conduct](https://software-carpentry.org/conduct/)

* [Mozilla Science Lab: Getting Started with Codes of Conduct](http://mozillascience.github.io/working-open-workshop/code_of_conduct/)

#### Shortly before the event

Make sure the Code of Conduct is clearly visible/accessible from the event website (if one exists); if your event does not have or need a website, print out the CoC and give it to participants.

#### During the event

Make sure there is a safe space for participants to report any breaches of the Code of Conduct. Communicate sanctions, and follow through if any breaches occur.

## <img src="/Images/Icons/badge.png" width="150" height="150" />
### Certification of attendance

#### Long before the event

Prepare a template and assign who will keep records or monitor registration process. 

#### Shortly before the event

Prepare a generic certificate of attendance with event or organiser’s logos and event information that can be distributed digitally when requested.  

#### During the event

Ask participants if a certificate of attendance is needed.

If a signature sheet is required, make sure you do a check during the day or ask to complete it at registration. 

## <img src="/Images/Icons/sign_left.png" width="150" height="150" /> <img src="/Images/Icons/sign_right.png" width="150" height="150" />
### Signs

#### Long before the event

Check the venue and define spots to be marked by signs to help participants to easily find a room. 

#### Immediately before the event

Design, print and place the signs and leave useful information at the reception desk. 

#### During the event

Remove the signs after the event.

## <img src="/Images/Icons/social_facebook.png" width="150" height="150" /> <img src="/Images/Icons/social_twitter.png" width="150" height="150" />
### Social media and notes 

#### Long before the event

Plan your social media activities, ask colleagues from other departments and/or partner organization to help you in sharing information. 

#### Immediately before the event

Prepare note documents (e.g. public Google Docs or etherpads). Make announcements on social media.

#### During the event

Ask your audience whether they are ok with being filmed, photographed and featured on social media. If it's a big audience, you might consider handing out stickers to those who do not want to be featured.

Assign note takers and people responsible for social media. Ideally, rotate heavily to avoiding slacking and loss of attention. 

## <img src="/Images/Icons/key.png" width="150" height="150" />
## Event closure

### Venue

Make sure you leave the venue neat and clean, unless your agreement for using it doesn’t require this.

### Debrief

Debrief with the other trainers/speakers to self-assess how the event went.

### Evaluation

Send post-training assessment survey to participants [link to evaluation/assessment chapter] or distribute an evaluation form during the event and make sure people hand it in at the end.

Read and count the questions in the evaluation form. Make your self-evaluation.

### Dissemination

Upload all the material used during the event (presentations, documents) if they were not available beforehand. Make sure to provide open licenses if possible, and make sure participants are not identifiable (e.g., within a notes document). 

Prepare a report for your funder or institution and if needed make it public (e.g. blog, twitter, website). 

## <img src="/Images/Icons/coffee_break.png" width="150" height="150" /> <img src="/Images/Icons/toilets.png" width="150" height="150" />
## Checklist

<table>
  <tr>
    <td>What</td>
    <td>When and who?</td>
    <td>Done?</td>
  </tr>
  <tr>
    <td>Equipment/media</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Determine what technical equipment is needed</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Check if enough power outlets are available</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Order wifi for participants</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Organize video recording and taking pictures</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Test equipment a few days before the training</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Print out handouts, feedback forms and material for exercises or publish them online</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Prepare flip charts and pinboards</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Venue</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Check elevator access, accessible entrances, ramps</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Check public transport and parking availability</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Locate maternity room, prayer room and gender neutral washrooms</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Clear, legible signs</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Brief your helpers before the event</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Marketing/advertising</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Identify communication channels</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Set up online presence</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Send event information to mailing lists</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Inform about your event in social media</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Registration</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Set up registration module</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Collect information on dietary needs and allergies</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Ask for childcare needs</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Provide hotel information for events over several days</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Send confirmations/invitations to attendees and provide clear text and image instructions to the venue</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Send a reminder 1 or 2 days before the event</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Prepare name tags and print participants list</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Prepare a registration desk</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Organise a wardrobe checkroom for larger events</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Catering</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Identify catering options and needs</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Order catering </td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Check if meals are clearly labeled (especially regarding dietary needs and allergies)</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Communication during event</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Inform the participants where to find emergency exits, food/beverages and restrooms etc.</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Hand out consent forms for video recordings, live streaming and/or photos</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Post event dissemination</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Make photos of flip charts and other non-digital material or results</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Hand out or send certificates of attendance</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Provide or send training material (slides, notes, video recordings) to the attendees</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Provide a report for your funder or institution</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Evaluation</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Hand out or provide an online or printed form for feedback</td>
    <td></td>
    <td></td>
  </tr>
</table>

## <img src="/Images/Icons/magnifying_glass.png" width="150" height="150" />
## References

Wilson G. Software Carpentry: lessons learned [version 2; referees: 3 approved]. F1000Research. 2016;3:62: [doi.org/10.12688/f1000research.3-6e 2.v2](https://doi.org/10.12688/f1000research.3-62.v2) 

Christodolou et al., (2014) How to conduct a successful workshop: The trainee’s perspective (Arab Journal of Urology), 12(1), 12-14: [doi.org/10.1016/j.aju.2013.08.004](https://doi.org/10.1016/j.aju.2013.08.004)

Pavelin et al., (2014) Ten simple rules for running interactive workshops, *PLOS Biology*: [doi.org/10.1371/journal.pcbi.1003485](https://doi.org/10.1371/journal.pcbi.1003485)

Commission on Disability Rights of American Bar Association (2016): Planning Accessible Meetings and Events.  [A toolkit](https://www.americanbar.org/content/dam/aba/administrative/mental_physical_disability/Accessible_Meetings_Toolkit.authcheckdam.pdf).

[Conference Planning Checklist](https://sparcopen.github.io/opencon-dei-report/checklist.html) by SPARC

**Inspirations**

* Software Carpentry [Workshop Operations](https://software-carpentry.org/workshops/operations/)

* Software Carpentry [Admin Checklist](https://software-carpentry.org/checklists/admin/) 

* Wikihow [Conduct a Workshop](https://www.wikihow.com/Conduct-a-Workshop)

* SPA 2010 Guidelines[Organising training seminars workshops](https://www.ica.org/sites/default/files/SPA_2010_Guidelines_Organising-training-seminars-workshops_EN.pdf)

