## <img src="/Images/Icons/idea.png" width="200" height="200" />
## Glossary

**Altmetrics**

* Altmetrics are alternative ways of recording and measuring the use and impact of scholarship. Rather than solely counting the number of times a work is cited in scholarly literature, alternative metrics also measure and analyze social media (e.g., Facebook, Twitter, blogs, wikis, etc.), document downloads, links to publishing and unpublished research, and other uses of research literature, in order to provide a more comprehensive measurement of reach and impact.

**Audience**

* The group addressed by a communication (e.g., those in attendance of an Open Science training). The target audience is a group of individuals that will be addressed or affected by the training.

**Behaviorism (Learning Theory)**

* Behaviorism means that learning is governed by drill-and-practice and is best done with the use of stimuli to which the learners respond. This generally means that you ask the learner to do an exercise for which there is a clear answer or a clear path to follow. Evaluation is clear and can easily be done with the help of simple metrics.

**Cognitivism**

* Cognitivism is based on the interaction between the outer world and what the reflecting brain makes out of the information perceived in combination with the knowledge that it has already stored. Cognitivism concentrates therefore on problem solving.

**Connectivism**

* Connectivism is the integration of principles explored by chaos, network, complexity and self-organization theories. Connectivism is driven by the understanding that decisions are based on rapidly altering foundations, as new information is continually being acquired. 

**Constructivism**

* Constructivism in the strict sense means the world is not as it is. Instead the world is primarily the product of our individual experiences and minds. In the context of teaching and learning this means that learners themselves create the path of learning. The focus is hence on the learner’s creativity and evaluation of progress is not based on the differentiation between right or wrong.

**Copyright**

* The aspect of Intellectual property that grants creators the right to permit (or not permit) the reproduction of their creations. It is distinct from trademark rights or moral rights.

**Creative Commons**

* A suite of standardized licences that allow copyright holders to grant some rights to users by default. CC licences are widely used, simple to use, machine readable, and have been created by legal experts. There are a variety of CC licences, each of which use one or more clauses. Some licences are compatible with Open Access in the Budapest sense (CC0 or those carrying the BY, SA, and ND clauses), and some are not (carrying the NC clause). 

**Curriculum**

* Curriculum refers to the lessons and other training content taught in a school or in a specific course or program within a defined structure.

**Data**

* Data in the sense used here are all digitally available objects (simple or complex) that emerge or are the result of the research process.

**Data Mining**

* An analytic process designed to explore data in search of consistent patterns or systematic relationships between variables, transforming data into information for future use.

**Digital Object Identifier (DOI)**

* A unique text string that is used to identify digital objects such as journal articles, data sets or open source software releases. A DOI is one type of Persistent Identifier (PID).

**Documentation**

* A documentation is detailed information as well as background and methodological approach about the data or code (e.g., description of the project, variables, and measuring instruments). 

**FAIR Data**

* FAIR Data (according to [FORCE11 principles](https://www.force11.org/group/fairgroup/fairprinciples) and published in [Nature Scientific Data](https://www.nature.com/articles/sdata201618)) are Findable, Accessible, Interoperable, and Re-usable, in order to facilitate knowledge discovery by assisting humans and machines in their discovery of, access to, integration and analysis of, task-appropriate scientific data and their associated algorithms and workflows.

**Gamification**

* The use of game design elements and game mechanics in non-game contexts, such as education where it can be used to bring extra engagement.

**GDPR**

* (General Data Protection Regulation) seeks to create a harmonised data protection law framework across the EU. It aims to restitute the control of personal data to citizens, whilst imposing strict rules on those hosting and 'processing' these data, anywhere in the world. The Regulation also introduces rules relating to the free movement of personal data within and outside the EU.

**Impact Factor**

* A numerical measure that indicates the average number of citations to articles published over the previous two years in a journal. It is frequently used as a proxy for a journal's relative importance. Its transfer to the impact of individual articles published in a journal is considered to be problematic.

**Intellectual Property**

* A legal term that refers to creations of the mind. Examples of intellectual property include music, literature, paintings, sculpturing, video and other artistic works; discoveries and inventions; and phrases, symbols, and designs.

**Journal**

* A series of published research articles. Historically divided into volumes and issues.

**Licence**

* A license allows a third party to perform certain actions with a work or data. The license informs about the usage rights of a resource (e.g. text, data, source code).

**Metadata**

* Metadata provide a basic description of the data, often including authorship, dates, title, abstract, keywords, and license information. They serve first and foremost the findability of data (e.g. creator, time period, geographic location). They.

**Open Access**

* Open Access refers to online, free of cost access to peer reviewed scientific content with free reusability regarding copyright restrictions.

**Open Data**

* Open Data are online, free of cost, accessible data that can be used, reused and distributed provided that the data source is attributed.

**Open Evaluation**

* The development of a fair evaluation system or protocol for research proposals, based on transparency of the process and those involved.

**Open Lab Notebooks**

* A concept of writing about research on a regular basis, such that research notes and data are accumulated and published online as soon as they are obtained.

**Open Materials**

* Sharing of research materials, for example, biological and geological samples, is another Open Science practice.

**Open Peer Review**

* An umbrella term for a number of overlapping ways that peer review models can be adapted in line with the aims of Open Science, including making reviewer and author identities open, publishing review reports and enabling greater participation in the peer review process.

**Open Science**

* Open science is the movement to make scientific research, data and dissemination accessible to all levels of an inquiring society.

**Open Source**

* Availability of source code for a piece of software, along with an open source license permitting reuse, adaptation, and further distribution.

**Peer Review**

* A process by which a research article is vetted by experts from the community before publication.

**Persistent Identifier (PID)**

* A persistent identifier (also PID) is a unique and stable denomination (reference) of a digital resource (e.g. research data) through allocation of a code that can be persistently and explicitly referenced on the internet.

**Persistent/Preferred File Formats **

* Non-proprietary formats that follow documented international standards, are commonly used by the research community, use standard character encoding (e.g. ASCII, UTF-8), and were compression, if used at all, is lossless.

**Preprint**

* A manuscript draft that has not yet been subject to formal peer review, distributed to receive early feedback on research from peers.

**Preregistration**

* Researchers have the option or are required to submit important information about their study (for example: research rationale, hypotheses, design and analytic strategy) to a public registry before beginning the study. Preregistration can help counter reporting bias.

**README file**

* File where you document your research data. The documentation should be sufficient to enable other researchers to understand, replicate or reproduce the data or reuse them in any other way.

**Reporting Bias**

* Reporting bias occurs when certain aspects of a study are systematically not reported transparently, creating wastage and redundancy through selective reporting or non-publishing.

**Repository**

* Repository is defined as the infrastructure and corresponding service that allows for the persistent, efficient and sustainable storage of digital objects (such as documents, data and code). 

**Reproducible Research**

* Reproducibility is a spectrum and instructors should choose the definition most used by their audience. Generally speaking, reproducible research makes it possible to obtain similar results of a study or experiment and independent results obtained with the same methods but under different conditions (i.e., pertains to results). Some break the definition into levels of reproducibility, including computationally reproducible (also called "reproducible"): where code and data can be analyzed in a similar manner as in the original research to achieve the same results, and empirically reproducible (also called “replicable”): where an independent researcher can repeat a study using the same methods but creating new data.

**Research Impact**

* Involve academic, economic and societal aspects, or some combination of all three. Impact is the demonstrable contribution that research makes in shifting understanding and advancing scientific, method, theory and application across and within disciplines, and the broader role that this plays outside of the research system.

**Research Funder**

* An institute, corporation or government body that provides financial assistance for research.

**Scholarly Communication**

* The creation, transformation, dissemination, and preservation of knowledge related to teaching, research, and scholarly endeavors; the process of academics, scholars and researchers sharing and publishing their research findings so that they are available to the wider academic community. The creation, transformation, dissemination, and preservation of knowledge related to teaching, research, and scholarly endeavors; the process of academics, scholars and researchers sharing and publishing their research findings so that they are available to the wider academic community.

**Sharing**

* The joint use of a resource or space. A fundamental aspect of collaborative research. As most research is digitally-authored & digitally-published, the resulting digital content is non-rivalrous and can be shared without any loss to the original creator.

**Subscription**

* A form of business model whereby a fee is paid in order to gain access to a product or service - in this case, the outputs of scholarly research.

**Trainer**

* The moderator and instructor of a training, whose role is to ensure the training objectives are met, run the practice, and ensure no one is left out.

**Training**

* Training is any organised activity that teaches, informs, or transfers skills or knowledge on specific useful competencies through active, engaged learning. 

**Training Format**

* A conventionally named, standardised delivery method that is applied by a trainer and includes any number of the pedagogical tools necessary (i.e. motivation/demotivation, hands-on approaches, etc).

**Version Control**

* Version control is the management of changes to documents, computer programs, large web sites, and other collections of information in a logical and persistent manner, allowing for both track changes and the ability to revert a piece of information to a previous revision.

## Additional Resources

* [Open Research Glossary](http://www.righttoresearch.org/resources/OpenResearchGlossary/index.shtml), hosted by the R2RC.

* [FOSTER Taxonomy](https://www.fosteropenscience.eu/foster-taxonomy/open-science-definition)

* [Open Definition](http://opendefinition.org/)

* [Lexicon-of-Learning (ASCD)](http://www.ascd.org/Publications/Lexicon-of-Learning/table-of-contents.aspx)

