## <img src="/Images/Icons/public.png" width="200" height="200" /> <img src="/Images/Icons/handson.png" width="200" height="200" />
# About the authors & facilitators

## Authors at the sprint event

### Sonja Bezjak

* University of Ljubljana, Slovenia
* [sonja.bezjak@fdv.uni-lj.si](mailto:sonja.bezjak@fdv.uni-lj.si)
* [@sonja\_adp](https://twitter.com/sonja_adp)

In the Social Science Data Archives I am primarily engaged with issues related to open access to research data. One of my roles is to train different stakeholders on research data policy, research data management planning, data citation, data publications etc. As a member of CESSDA ERIC training group I try to share my knowledge and experience internationally.

I was taught about scientific values, including transparency and reproducibility while studying sociology. But only later from my friends, a physicist and an engineer, I learnt about the Open Source movement. I immediately understood the importance of spreading the idea of not hiding your findings and sharing your knowledge with others as soon as possible. Only when I started to work at the Social Science Data Archives \(University of Ljubljana, Slovenia\) and became heavily involved in the Open data project I realized how much effort was needed to change the culture and to be able to get over the barriers of not openly sharing research outputs. I hope this handbook will help in making science as open and understandable as possible.

### Philipp Conzett

* UiT The Arctic University of Norway, Norway
* [philipp.conzett@uit.no ](mailto:philipp.conzett@uit.no )
* [@philippconzett](https://twitter.com/philippconzett)
* [0000-0002-6754-7911](https://orcid.org/0000-0002-6754-7911)

Trained as a linguist, I only had a vague understanding of Open Science when I started to work as a research librarian at UiT The Arctic University of Norway back in 2014. Luckily, I soon was involved in developing and running research support services, including repositories for open research data, starting with a discipline-specific one \(TROLLing\), then an institutional one \(UiT Open Research Data\), and finally a nationwide one \(DataverseNO\). Participating in the Open Science book sprint has been a fruitful contribution to my training competence.

There are two major pitfalls for Open Science trainers, as I see it. One, novice trainers may feel so overwhelmed by the topics to cover, and the available resources that they don’t get started. Two, experienced trainers promoting Open Science may turn their efforts too much into a movement only accessible for the initiated. I hope this book can help to overcome both obstacles.

### Pedro L. Fernandes

* Instituto Gulbenkian de Ciência, Portugal
* [pfern@igc.gulbenkian.pt](mailto:pfern@igc.gulbenkian.pt)
* [@pfern](https://twitter.com/pfern)
* [0000-0003-2124-0241](https://orcid.org/0000-0003-2124-0241)

I run a training programme in Bioinformatics at the Instituto Gulbenkian de Ciência, in Oeiras, PT since 1999. More than 5000 course participants in 19 years. Extending this activity with distance and e-learning, to better reach for 21st century learners.  I am an advocate of Open Access, Open Data, Open Source and Open Science that takes any possible chance to put these causes through via training. I am conscious that this movement needs to scale-up and reach for non-scientists as well, so I am very interested in its amplification and diffusion.

Open Science is an attitude that requires a large but feasible education step. Advocates like me need to join forces and make it happen every day. Training in Open Science is needed at a wide range of levels. To address the entry level, together with Rutger A.Vos, we prepared the free e-book "Open Science, Open Data, Open Source" in 2017 \([http://osodos.org](http://osodos.org)\). More advocacy and training to come.

### Edit Görögh

* University of Göttingen, Germany
* [goeroegh@sub.uni-goettingen.de](mailto:goeroegh@sub.uni-goettingen.de)
* [@gorogh\_edit](https://twitter.com/gorogh_edit)
* [0000-0002-0766-418X](https://orcid.org/0000-0002-0766-418X)

I am currently working at the University of Göttingen as a project officer for OpenUP, an EU funded project which aims at developing a cohesive framework for new methods, indicators and tools for peer review, dissemination of research results, and impact measurement. I have been in involved in knowledge management and open science/access related programs for more than 10 years.

Working for Open Science projects, I had the chance to get acquainted with both the diverse community of Open Science advocates and the reluctant, skeptical groups of researchers and decision makers, which both urged me to get more immersed in the Open Science discourse and follow developments and learn about the tools and methods to speak effectively about the benefits and challenges we face in the changing world of research communications.

### Kerstin Helbig

* Humboldt-Universität zu Berlin, Germany
* [kerstin.helbig@cms.hu-berlin.de](mailto:kerstin.helbig@cms.hu-berlin.de)
* [@FrauHelbig](https://twitter.com/FrauHelbig)
* [0000-0002-2775-6751](https://orcid.org/0000-0002-2775-6751)

I am research data management coordinator at Humboldt-Universität zu Berlin, Germany. In my consultative capacity, I assist researchers in the management of their research data and organize training as well as information sessions.

For me the biggest challenge with open science training is to show researchers that open science is more than a political aim or a moral responsibility. It is essential to show that there are levels of open science. One can start with a little step without having to open up completely from one day to another. In my trainings, I especially like the mix of backgrounds, disciplines and prior knowledge. They make the training all the more interesting. I remember one training course in particular: one participant \(a professor\) registered an ORCID on the spot while I was talking about the advantages of persistent identifiers.

### Bianca Kramer

* Utrecht University, Netherlands
* [b.m.r.kramer@uu.nl](mailto:b.m.r.kramer@uu.nl)
* [@MsPhelps](https://twitter.com/MsPhelps)
* [0000-0002-5965-6560](https://orcid.org/0000-0002-5965-6560)

By day, I am a librarian for life sciences and medicine. My after hours project is [101 Innovations in Scholarly Communication](https://101innovations.wordpress.com) together with Jeroen Bosman. We do research, training and advocacy on open science, to make research more relevant, robust and equitable. 

Training in open science is rewarding because it is not just about teaching people new skills, it's about discussing fundamental concepts and exchanging different viewpoints and opinions. As a participant in one of our courses said: 'I came to learn practical things to apply in my research, but I discovered I am now part of a movement'. To me, a succesfull training should be interactive and hands-on, to  encourage people to explore and challenge their perceptions. That includes my own role as a trainer: always be open to try new things and learn from the people participating in your training.   

### Ignasi Labastida

* Universitat de Barcelona, Catalonia
* [ilabastida@ub.edu](mailto:ilabastida@ub.edu)
* [@ignasi](https://twitter.com/ignasi)
* [0000-0001-7030-7030](https://orcid.org/0000-0001-7030-7030)

PhD in Physics, Universitat de Barcelona (UB), 2000. Now, devoted to openness: Head of the [Office for the Dissemination of Knowledge](http://crai.ub.edu/en/crai-services/intellectual-property) at the CRAI of the UB and public leader of Creative Commons in Spain since its beginning in 2003.

I hope in the near future there will be no need to train about open science because those practices, now described here, will be the default ones. There will be no need to attach the open tag anymore, and researchers would need to justify why they close some of their results or activities. I think this book may help to achieve this situation by showing a lot of robust examples and viable cases to perform research openly.

### Kyle Niemeyer

* Oregon State University, USA
* [kyle.niemeyer@oregonstate.edu](mailto:kyle.niemeyer@oregonstate.edu)
* [@kyleniemeyer](https://twitter.com/kyleniemeyer)
* [0000-0003-4425-7097](https://orcid.org/0000-0003-4425-7097)

I am an Assistant Professor of Mechanical Engineering at Oregon State University in Corvallis, Oregon, USA. My research group studies combustion and fluid flows using computer simulations, and develop numerical methods and parallel computing strategies. Open science advocate!

As a graduate student, I frequently faced roadblocks in my research due to software not being shared openly; now, as the leader of a research group, my students and I face data availability and formatting challenges when working with results in the literature. However, simply showing others how easy it can be to share research products openly can be enough to catalyze change, as can leading by example.

### Fotis Psomopoulos

* Center for Research and Technology Hellas, Greece
* [fpsom@issel.ee.auth.gr](mailto:fpsom@issel.ee.auth.gr)
* [@fopsom](https://twitter.com/fopsom)
* [0000-0002-0222-4273](https://orcid.org/0000-0002-0222-4273)

Fotis is a Bioinformatician at the Institute of Applied Biosciences \(INAB\|CERTH\) in Thessaloniki, Greece. He was awarded his PhD in Electrical and Computer Engineering in 2010 with a focus on Bioinformatics and e-infrastructures, and a particular appreciation to open and reproducible methods. He spends significant time in training activities, both within formal academic structures as well as through the Carpentries as a certified Instructor and Trainer. He rambles about bits and pieces on his website.

Convincing people that spending the extra time to put together a Jupyter notebook with all the text, notes, scripts and data currently stored in various "dusty" and forgotten folders on their computer, will actually help them become a bit more organized. \#smallvictories \#reproducibility

### Tony Ross-Hellauer

* Know-Center GmbH, Austria
* [tross@know-center.at](mailto:tross@know-center.at)
* [@tonyR\_H](https://twitter.com/tonyR_H)
* [0000-0003-4470-7027](https://orcid.org/0000-0003-4470-7027)

Tony Ross-Hellauer is Senior Researcher \(Open Science\) at Know-Center, Graz, Austria. He has a PhD in Information Studies \(University of Glasgow, 2012\) and is an enthusiastic advocate of Open Access and Open Science whose research interests include peer review, metadata, and the philosophy/history of technology.

Although creating and delivering training events is very daunting, training others not only to do Open Science, but also to see the value of it for their everyday research, is one of the most rewarding aspects of working in this area. As a trainer, when learners are engaged to share their own experiences and you can feel how they are able to relate their new knowledge to these experiences, it is very exciting.

### René Schneider

* HES//SO - Geneva School of Business Administration, Switzerland
* [rene.schneider@hesge.ch](mailto:rene.schneider@hesge.ch)
* [@datosestupendos](https://twitter.com/datosestupendos)
* [0000-0003-4897-8561 ](https://orcid.org/0000-0003-4897-8561)

René Schneider is a professor in Information Science at Geneva School of Business Administration \(being part of the University of Applied Sciences and Arts Western Switzerland\). Originally trained as a computational linguist, he is mainly interested in data and all of its aspects.

I discovered the field of research data management  quite lately and mainly got engaged because of the complexity and high potential of open science. After having managed a project on how to train librarians to become instructors for research data management \(www.researchdatamanagement.ch\), I experienced myself that open science open doors, leads to a better understanding and reuse of scientific outcomes and finally links the academic ivory tower to the world outside.

### Jon Tennant

* Open Science MOOC, Germany
* [jon.tennant.2@gmail.com](mailto:jon.tennant.2@gmail.com)
* [@protohedgehog](https://twitter.com/protohedgehog)
* [0000-0001-7794-0218](https://orcid.org/0000-0001-7794-0218)

Jon finished his award-winning PhD in Palaeontology at Imperial College London in 2017, and became the Communications Director of ScienceOpen for two years in 2015. Now, he is independently continuing his research into dinosaur evolution, while working on building an Open Science MOOC to help train the next generation of researchers in open practices. He has published papers on Open Access and Peer Review, is currently leading the development of the Foundations for Open Science Strategy document, and is the founder of the digital publishing platform paleorXiv. Jon is also an ambassador for ASAPbio and the Center for Open Science, a Mozilla Open Leadership mentor, and the co-runner of the Berlin Open Science meetup. He is also a freelance science communicator and consultant, and has written a kids book called Excavate Dinosaurs.

I think the most challenging aspect of Open Science is education. It is an enormously complex paradigm, with its own lexicon, practices, principles, and represents a quite high learning barrier in many cases. However, watching others develop their knowledge and skills is incredibly rewarding, and I find myself learning more with every new experience too. Ultimately, we all have the same thing in mind - a fairer, more equitable, transparent and rigorous system of scientific research, and watching the huge steps the global research community, and especially younger generations, are taking towards this is very inspiring.&lt;/td&gt;

### Ellen Verbakel

* 4TU.Centre for Research Data, Netherlands
* [p.m.verbakel@tudelft.nl](mailto:p.m.verbakel@tudelft.nl)
* [@Ellen4TUData](https://twitter.com/Ellen4TUData)
* [0000-0002-8194-6724](https://orcid.org/0000-0002-8194-6724)

Ellen is a librarian by education. She has a long experience in faculty librarianship at the TU Delft. After that she worked at the Delft University Press and organised peer review process for three journals. She also designed the open access or the journals, back in 2000! As from 2005 she developed the publication repository from TU Delft and she moved to 4TU.Centre for Research Data \(at that time 3TU.Datacentrum\) in 2009. In 2013 she co-designed the training Essentials 4 Data Support, she is since then an enthusiastic trainer.

Where would we be without training? We need to be aware of all aspects of Open Science and be able to enthusiasm many others! This Handbook helps educators to make their training more effective in order to make Open Science the standard.

## Authors at the sprint event remotely

### April Clyburne-Sherin

* Code Ocean, USA
* [april.clyburne.sherin@gmail.com](mailto:april.clyburne.sherin@gmail.com)
* [@april\_cs](https://twitter.com/april_cs) & [@methodpodcast](https://twitter.com/methodpodcast)
* [0000-0002-5401-7751](https://orcid.org/0000-0002-5401-7751)

April is an epidemiologist, methodologist, and expert in open science tools, methods, training, and community stewardship. She holds an MS in Population Medicine (Epidemiology). Since 2014, she has focussed on training scientists in open and reproducible research methods (Center for Open Science, Sense About Science, SPARC). In her current role of Outreach Scientist, she trains scientists in computational reproducibility best practices using Code Ocean.

I have been lucky enough to make a living out of training other scientists how to science better. My community of support grows with each workshop and I hope this handbook might help grow the open research training community. Conversations about open research often occur in echo-chambers of well-meaning researchers \(like myself\) and librarians with similar worldviews. Training in open research can be similarly siloed with Western or Northern perspectives being taught as though universal. Adding context and new perspectives to open research conversations is the only way to make knowledge work for everyone. The content we captured during this sprint is limited by our own experiences, but as other authors add and edit based on their own experiences, we can aim for a handbook that can improve how we talk and train others in open research.

## Facilitators on site

### Helene Brinken

* University of Göttingen, State and University Library, Germany
* [brinken@sub.uni-goettingen.de](mailto:brinken@sub.uni-goettingen.de)
* [@helenebrinken](https://twitter.com/helenebrinken)
* [0000-0002-3278-0422](https://orcid.org/0000-0002-3278-0422)

Responsible for Outreach and Advocacy in the FOSTER project at Göttingen University since May 2017. Background in Information Science with focus on e-learning and usability & user experience, now developing learning materials and facilitating workshops.

Before working for FOSTER I worked with young activists engaging for worldwide education and against social injustice. I learned how important group dynamics are and what can be achieved when combining forces. Culture change starts at the level of individuals. Bringing together the researchers interested in Open Science can be a great step forward to foster OS at your institution. If they get support, meet other enthusiasts and learn they can soon be multiplicators themselves.

### Lambert Heller

* TIB - German National Library of Science and Technology, Hannover, Germany
* [lambert.heller@tib.eu](mailto:lambert.heller@tib.eu)
* [@Lambo](https://twitter.com/Lambo)
* [0000-0003-0232-7085](https://orcid.org/0000-0003-0232-7085)

With a background in social sciences, I’m a librarian by training, working as a subject specialist at a university library for several years, and kicked of the Open Science Lab at TIB \(German National Library for Science and Technology\) in 2013, now running a number of grant projects. Facilitating and advising book sprints since 2014. Helped to make VIVO, a free current research information system \(CRIS\) based entirely on Linked Open Data, popular in Germany. Kicked of a few discussions in libraryland and elsewhere, e.g. on Blockchain for Science.

When giving workshops \(e.g., a half day workshop for PhD students and PostDocs from Leibniz Research Association in Germany in 2017, on the matter of scholarly profile and collaborative writing services\) it’s always a pleasure to tap into the curiosity of learners. Even the busiest student has experiences, questions and imagines how things could work best for them. I love to make use of this positive energy! And it makes it much easier for a trainer to run a training session.

